/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicalUserInterface;
 
import datasource.InMemoryDataSource;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComboBox;
import products.WritingImplement;
 
public class C_AddingFunctionality extends JPanel {
    
    //The datasource that we will be using
    private static InMemoryDataSource datasource = new InMemoryDataSource();
    //Has to be this specific implementation as only this implementation gives us access to the lists.
 
    public C_AddingFunctionality() {
        //Show a 'blank list' initially until a valid price list is selected
        PriceListTableModel data =new PriceListTableModel(datasource.retrieveList("Empty"));
 
        final JTable table = new JTable(data);
        table.setPreferredScrollableViewportSize(new Dimension(1000, 140));
        table.setFillsViewportHeight(true);
 
        //Create the scroll pane and add the table to it.
        JScrollPane scrollPane = new JScrollPane(table);
 
        //Add the scroll pane to this panel.
        add(scrollPane);
        
        //Create a text field and a button       
//        JTextField listNameField = new JTextField("Demo");
        JButton setListButton = new JButton("Change List");
        //Once the text and button are working make the text field a popup containing all the existing price lists
        JComboBox<String> listNameField = new JComboBox(datasource.lists.keySet().toArray());
        
        //Set the action of the button so that the name of hte list is set to the name tyed in the text field
        setListButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
//                listNameField.setText("Hello World");
//                PriceListTableModel data =new PriceListTableModel(
//                        (new InMemoryDataSource()).retrieveList(listNameField.getText()));
                //To fetch the value from the combobox instead of the text field
                PriceListTableModel data =new PriceListTableModel(
                        datasource.retrieveList((String) listNameField.getSelectedItem()));
                table.setModel(data);
            }
        });
        add(listNameField);
        add(setListButton);
    }
 
    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Create and set up the window.
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
 
        //Create and set up the content pane.
        C_AddingFunctionality newContentPane = new C_AddingFunctionality();
        newContentPane.setOpaque(true); //content panes must be opaque
        frame.setContentPane(newContentPane);
 
        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }
 
    public static void main(String[] args) {
        //Add some pricelists to our datasource before we start
        datasource.saveList("Empty",datasource.retrieveList("Demo").filterList(i->false));
        datasource.saveList("Writing Implements",datasource.retrieveList("Demo").filterList(i->i instanceof WritingImplement));
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}

